/*+ TsipParser.h
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2005 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file defines the CTsipParser class.
 *            
 * Revision History:
 *    01-11-2007    Jacob Norda
 *                  Written
 *
 * Notes:
 *
-*/

#ifndef PARSER_DEFINITIONS_H
#define PARSER_DEFINITIONS_H

/*---------------------------------------------------------------------------*\
 |                     S I M P L E   D A T A   T Y P E S
\*---------------------------------------------------------------------------*/
typedef char			S8;              /* Signed 8-bit integer (character) */
typedef unsigned char   U8;              /* Unsigned 8-bit integer (byte)    */
typedef signed short    S16;             /* Signed 16-bit integer (word)     */
typedef unsigned short  U16;             /* Unsigned 16-bit integer (word)   */
typedef signed long     S32;             /* Signed 32-bit integer (long)     */
typedef unsigned long   U32;             /* Unsigned 32-bit integer (long)   */
typedef float           FLT;             /* 4-byte single precision (float)  */
typedef double          DBL;             /* 8-byte double precision (double) */


/*---------------------------------------------------------------------------*\
 |                  C O N S T A N T S   A N D   M A C R O S
\*---------------------------------------------------------------------------*/
#define MSG_IN_ERROR     -1
#define MSG_IN_COMPLETE  0

#define TSIP_DLE         1
#define TSIP_IN_PARTIAL  2

#define NMEA_CR          1
#define NMEA_IN_PARTIAL  2

#define PROTOCOL_DETERMINE 0
#define PROTOCOL_TSIP 1
#define PROTOCOL_NMEA 2

#define GPS_PI           (3.1415926535898)
#define R2D              (180.0/GPS_PI)

#define MAX_LONG         (2147483648.)   /* 2**31 */

static const char* gstrDayName[7] = 
{
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};


#endif